define([
    'underscore',
    'marionette',
    'jqm',
],
function(_, Marionette) {
    'use strict';

    return Marionette.View.extend({
        className: 'dialog',
        attributes: {
            'data-role': 'popup',
            'data-overlay-theme': 'a',
        },
        events: {
            'popupbeforeposition': 'styleMaxHeight',
            'popupafteropen': 'focusOnHeader',
            'popupafterclose': 'destroy',
            'click button': 'closePopup',
        },
        initialize: function(options) {
            this._initializeElAfterClose(options);
        },
        _initializeElAfterClose: function(options) {
            var el;

            this.elAfterClose = $();

            el = options.elAfterClose;
            if (!_.isUndefined(el)) {
                if (typeof el === 'string' ||
                    el instanceof Node ||
                    el instanceof HTMLElement ||
                    el instanceof jQuery) {
                    this.elAfterClose = el;
                } else {
                    // eslint-disable-next-line max-len
                    throw new Error('Element after popup closes must be specified as a selector string, DOM Node, HTML Element, or a jQuery object');
                }
            }
        },
        onRender: function() {
            this.$el.popup({dismissible: false});
            this.addAriaRole();
        },
        addAriaRole: function() {
            this.$el.attr('role', 'dialog');
        },
        onDestroy: function() {
            this.stopListening();
            this.off();
            this.remove();
        },
        styleMaxHeight: function() {
            var windowHeight = $(window).height();
            // tolerance is configured in jqm-config
            var topTolerance = 30;
            var bottomTolerance = 30;
            this.$el.css('max-height', (windowHeight - topTolerance - bottomTolerance) + 'px');
        },
        focusOnHeader: function() {
            this.$el.find('.ui-title').focus();
        },
        focusOnElAfterClose: function() {
            var $el;

            if (typeof this.elAfterClose === 'string' ||
                this.elAfterClose instanceof Node ||
                this.elAfterClose instanceof HTMLElement) {
                $el = $(this.elAfterClose);
            } else {
                $el = this.elAfterClose;
            }

            $el.focus();
        },
        openPopup: function() {
            this.render();
            this.$el.popup('open');
        },
        closePopup: function() {
            this.$el.popup('close');

            this.focusOnElAfterClose();
        },
    });
});
